import base64
import hashlib


def content_encoding(path: str):
    """
    文件转 bytes 加密并使用 base64 编码
    :param path: 文件路径
    :return: 返回加密编码后的字符串
    """
    with open(path, 'rb') as f:
        content = f.read()
    content_md5 = hashlib.md5()
    content_md5.update(content)
    content_base64 = base64.b64encode(content_md5.digest())
    return content_base64.decode("utf-8")

